<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Tables\Post;

use Erlage\Photogram\Data\Tables\AbstractTable;
use Erlage\Photogram\Data\Models\Post\PostModel;
use Erlage\Photogram\Data\Models\Post\PostValidator;
use Erlage\Photogram\Data\Dtos\Post\PostMetaHashtagsDTO;
use Erlage\Photogram\Data\Dtos\Post\PostDisplayContentDTO;

final class PostTable extends AbstractTable
{
    /*
    |--------------------------------------------------------------------------
    | table data
    |--------------------------------------------------------------------------
    */

    const TABLE_NAME = 'post';

    /*
    |--------------------------------------------------------------------------
    | fields/attributes
    |--------------------------------------------------------------------------
    */

    const ID = 'id';

    // ids

    const OWNER_USER_ID = 'owner_user_id';

    // display

    const DISPLAY_CAPTION = 'display_caption';

    const DISPLAY_LOCATION = 'display_location';

    const DISPLAY_CONTENT = 'display_content';

    // meta

    const META_HASHTAGS = 'meta_hashtags';

    // cache

    const CACHE_LIKES_COUNT = 'cache_likes_count';

    const CACHE_COMMENTS_COUNT = 'cache_comments_count';

    // stamp

    const STAMP_REGISTRATION = 'stamp_registration';

    const STAMP_LAST_UPDATE = 'stamp_last_update';

    /*
    |--------------------------------------------------------------------------
    | all properties must provide their camel case equivalent
    |--------------------------------------------------------------------------
    */

    const CAMEL_CASE_MAP = array(
        self::ID => 'id',

        self::OWNER_USER_ID => 'ownerUserId',

        self::DISPLAY_CAPTION  => 'displayCaption',
        self::DISPLAY_LOCATION => 'displayLocation',
        self::DISPLAY_CONTENT  => 'displayContent',

        self::META_HASHTAGS => 'metaHashtags',

        self::CACHE_LIKES_COUNT    => 'cacheLikesCount',
        self::CACHE_COMMENTS_COUNT => 'cacheCommentsCount',

        self::STAMP_REGISTRATION => 'stampRegistration',
        self::STAMP_LAST_UPDATE  => 'stampLastUpdate',
    );

    /*
    |--------------------------------------------------------------------------
    | required attributes
    |--------------------------------------------------------------------------
    */

    public static function getPrimaryAttribute(): string
    {
        return self::ID;
    }

    public static function getRegistrationStampAttribute(): string
    {
        return self::STAMP_REGISTRATION;
    }

    public static function getLastUpdateStampAttribute(): string
    {
        return self::STAMP_LAST_UPDATE;
    }

    public static function getOwnerAttribute(): string
    {
        return self::OWNER_USER_ID;
    }

    /*
    |--------------------------------------------------------------------------
    | meta getters
    |--------------------------------------------------------------------------
    */

    public static function getTableName(): string
    {
        return self::TABLE_NAME;
    }

    public static function getModelClassName(): string
    {
        return PostModel::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | table properties getters
    |--------------------------------------------------------------------------
    */

    public static function allAttributes(): array
    {
        return self::CAMEL_CASE_MAP;
    }

    /*
    |--------------------------------------------------------------------------
    | table modifiers
    |--------------------------------------------------------------------------
    */

    public static function validators(): array
    {
        return array(
            self::DISPLAY_CAPTION  => array(PostValidator::erlClass(), self::CAMEL_CASE_MAP[self::DISPLAY_CAPTION]),
            self::DISPLAY_LOCATION => array(PostValidator::erlClass(), self::CAMEL_CASE_MAP[self::DISPLAY_LOCATION]),
            self::DISPLAY_CONTENT  => array(PostValidator::erlClass(), self::CAMEL_CASE_MAP[self::DISPLAY_CONTENT]),

            self::META_HASHTAGS    => array(PostValidator::erlClass(), self::CAMEL_CASE_MAP[self::META_HASHTAGS]),
        );
    }

    public static function serializers(): array
    {
        return array(
            self::DISPLAY_CONTENT => PostDisplayContentDTO::serializer(),
            self::META_HASHTAGS   => PostMetaHashtagsDTO::serializer(),
        );
    }

    public static function deSerializers(): array
    {
        return array(
            self::DISPLAY_CONTENT => PostDisplayContentDTO::deSerializer(),
            self::META_HASHTAGS   => PostMetaHashtagsDTO::deSerializer(),
        );
    }
}
